﻿if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Order Details_Insert]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
    drop procedure [dbo].[Order Details_Insert]
GO
------------------------------------
-- 功能描述：增加一条记录 
-- 所属表格：Order Details[ ]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
DECLARE @OrderID int -- 订单ID
    SET @OrderID = 
DECLARE @ProductID int -- 产品ID
    SET @ProductID = 
DECLARE @UnitPrice money -- 单价
    SET @UnitPrice = 0
DECLARE @Quantity smallint -- 数量
    SET @Quantity = 1
DECLARE @Discount real -- 折扣
    SET @Discount = 0
 -- 调用存储过程 
 exec [Order Details_Insert] @OrderID,@ProductID,@UnitPrice,@Quantity,@Discount
 */
------------------------------------
CREATE PROCEDURE [Order Details_Insert] (
@OrderID    int = NULL,        -- 订单ID
@ProductID  int = NULL,        -- 产品ID
@UnitPrice  money = NULL,      -- 单价
@Quantity   smallint = NULL,   -- 数量
@Discount   real = NULL        -- 折扣

)
AS
INSERT INTO Order Details(
	[UnitPrice],[Quantity],[Discount]	 
)VALUES( 
	@UnitPrice,@Quantity,@Discount	
)
SELECT @ID = SCOPE_IDENTITY() -- 返回新加记录的唯一标识
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Order Details_Edit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Order Details_Edit]
GO
------------------------------------
-- 功能描述：修改一条记录 
-- 所属表格：Order Details[]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /* -- 测试代码 --
 -- 参数设置 
DECLARE @OrderID int -- 订单ID
    SET @OrderID = 
DECLARE @ProductID int -- 产品ID
    SET @ProductID = 
DECLARE @UnitPrice money -- 单价
    SET @UnitPrice = 0
DECLARE @Quantity smallint -- 数量
    SET @Quantity = 1
DECLARE @Discount real -- 折扣
    SET @Discount = 0
 -- 调用存储过程 
 exec [Order Details_Edit] @OrderID,@ProductID,@UnitPrice,@Quantity,@Discount 
 */
------------------------------------
CREATE PROCEDURE [Order Details_Edit]
@OrderID    int = NULL,        -- 订单ID
@ProductID  int = NULL,        -- 产品ID
@UnitPrice  money = NULL,      -- 单价
@Quantity   smallint = NULL,   -- 数量
@Discount   real = NULL        -- 折扣

AS 
UPDATE Order Details SET 
	 [UnitPrice] = @UnitPrice, [Quantity] = @Quantity, [Discount] = @Discount
WHERE 
	 [OrderID] = @OrderID, [ProductID] = @ProductID
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Order Details_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Order Details_Delete]
GO
------------------------------------
-- 功能描述：删除一条记录 
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
 -- 调用存储过程 
DECLARE @ID int
    set @ID=0
 exec [Order Details_Delete] @ID
 */
------------------------------------
CREATE PROCEDURE [Order Details_Delete]
	@OrderID int --待删除的主键
AS 
   
	    DELETE FROM [Order Details]	    WHERE OrderID = @OrderID 
     
     
GO   
     


